<?php
// /home/ubuntu/vtrius_web_system/public/index.php

// Main entry point and simple router for the Vtrius application

// Ensure configuration is loaded first (includes autoloader and session start)
require_once __DIR__ . 
'/../src/config.php
';

use Vtrius\Controllers\AuthController;
use Vtrius\Controllers\VideoController;
use Vtrius\Controllers\VideoSettingsController;
use Vtrius\Controllers\AbTestController;
// Add other controllers as needed
// use Vtrius\Controllers\UserController;
// use Vtrius\Controllers\AdminController;

// Simple Routing Logic
$requestUri = parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH);
$requestMethod = $_SERVER["REQUEST_METHOD"];

// Basic routing based on URI path
switch ($requestUri) {
    // --- Authentication Routes ---
    case 
    '/login.php
    ':
    case 
    '/login
    ': // Allow access without .php
        $controller = new AuthController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleLogin();
        } else {
            $controller->showLoginForm();
        }
        break;

    case 
    '/logout.php
    ':
    case 
    '/logout
    ':
        $controller = new AuthController();
        $controller->handleLogout();
        break;

    // --- User Routes (Placeholder) ---
    case 
    '/user/dashboard.php
    ':
    case 
    '/user/dashboard
    ':
        // $controller = new UserController();
        // $controller->showDashboard();
        // Placeholder - Requires Auth check
        require_once APP_ROOT . 
        '/Lib/Auth.php
        ';
        $auth = new \Vtrius\Lib\Auth();
        $auth->requireLogin(BASE_URL . 
        '/login.php
        ');
        echo 
        "<h1>User Dashboard (Placeholder)</h1><p>Welcome, " . htmlspecialchars($auth->getUsername()) . "!</p><a href=\"/logout\">Logout</a>";
        break;

    // --- User Video Routes ---
    case 
    '/user/videos.php
    ':
    case 
    '/user/videos
    ':
        $controller = new VideoController();
        $controller->listVideos();
        break;
    case 
    '/user/videos/upload.php
    ':
    case 
    '/user/videos/upload
    ':
        $controller = new VideoController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleUpload();
        } else {
            $controller->showUploadForm();
        }
        break;
    case 
    '/user/videos/delete.php
    ':
    case 
    '/user/videos/delete
    ':
        $controller = new VideoController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleDelete();
        } else {
            http_response_code(405);
            echo __(
            "method_not_allowed
            ");
        }
        break;
    case 
    '/user/videos/settings.php
    ':
    case 
    '/user/videos/settings
    ':
        $controller = new VideoSettingsController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleUpdateSettings();
        } else {
            $controller->showSettingsForm();
        }
        break;

    // --- User A/B Test Routes ---
    case 
    '/user/abtests.php
    ':
    case 
    '/user/abtests
    ':
        $controller = new AbTestController();
        $controller->listTests();
        break;
    case 
    '/user/abtests/create.php
    ':
    case 
    '/user/abtests/create
    ':
        $controller = new AbTestController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleCreate();
        } else {
            $controller->showCreateForm();
        }
        break;
    case 
    '/user/abtests/view.php
    ':
    case 
    '/user/abtests/view
    ':
        $controller = new AbTestController();
        $controller->viewTest();
        break;
    case 
    '/user/abtests/add_variation.php
    ':
    case 
    '/user/abtests/add_variation
    ':
        $controller = new AbTestController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleAddVariation();
        } else {
            http_response_code(405);
            echo __(
            "method_not_allowed
            ");
        }
        break;
    case 
    '/user/abtests/remove_variation.php
    ':
    case 
    '/user/abtests/remove_variation
    ':
        $controller = new AbTestController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleRemoveVariation();
        } else {
            http_response_code(405);
            echo __(
            "method_not_allowed
            ");
        }
        break;
    case 
    '/user/abtests/delete.php
    ':
    case 
    '/user/abtests/delete
    ':
        $controller = new AbTestController();
        if ($requestMethod === 
        'POST
        ') {
            $controller->handleDeleteTest();
        } else {
            http_response_code(405);
            echo __(
            "method_not_allowed
            ");
        }
        break;

    // --- Admin Routes (Placeholder) ---
    case 
    '/admin/dashboard.php
    ':
    case 
    '/admin/dashboard
    ':
        // $controller = new AdminController();
        // $controller->showDashboard();
        // Placeholder - Requires Admin check
        require_once APP_ROOT . 
        '/Lib/Auth.php
        ';
        $auth = new \Vtrius\Lib\Auth();
        $auth->requireAdmin(BASE_URL . 
        '/login.php
        '); // Redirects if not admin
        echo 
        "<h1>Admin Dashboard (Placeholder)</h1><p>Welcome, Admin " . htmlspecialchars($auth->getUsername()) . "!</p><a href=\"/logout\">Logout</a>";
        break;

    // --- Default Route / Home ---
    case 
    '/
    ':
        // Redirect to login or dashboard depending on auth status
        require_once APP_ROOT . 
        '/Lib/Auth.php
        ';
        $auth = new \Vtrius\Lib\Auth();
        if ($auth->isLoggedIn()) {
            $redirectUrl = $auth->isAdmin() ? 
            '/admin/dashboard
            ' : 
            '/user/dashboard
            ';
            header(
            'Location: 
            ' . BASE_URL . $redirectUrl);
        } else {
            header(
            'Location: 
            ' . BASE_URL . 
            '/login
            ');
        }
        exit;

    // --- Static Assets (Basic handling - A web server is better for this) ---
    // This is a fallback if .htaccess or server config isn't handling assets
    default:
        $publicFilePath = __DIR__ . $requestUri;
        if (preg_match(
        '/\.(?:css|js|jpg|jpeg|png|gif|webp|svg|mp4|webm|ogg)$/
        ', $requestUri) && file_exists($publicFilePath)) {
            // Determine MIME type
            $mimeTypes = [
                
                'css
                ' => 
                'text/css
                ',
                
                'js
                '  => 
                'application/javascript
                ',
                
                'jpg
                ' => 
                'image/jpeg
                ',
                
                'jpeg
                ' => 
                'image/jpeg
                ',
                
                'png
                ' => 
                'image/png
                ',
                
                'gif
                ' => 
                'image/gif
                ',
                
                'webp
                ' => 
                'image/webp
                ',
                
                'svg
                ' => 
                'image/svg+xml
                ',
                
                'mp4
                ' => 
                'video/mp4
                ',
                
                'webm
                ' => 
                'video/webm
                ',
                
                'ogg
                ' => 
                'video/ogg
                ',
            ];
            $extension = strtolower(pathinfo($publicFilePath, PATHINFO_EXTENSION));
            $mimeType = $mimeTypes[$extension] ?? 
            'application/octet-stream
            ';
            
            header(
            'Content-Type: 
            ' . $mimeType);
            readfile($publicFilePath);
            exit;
        }
        
        // --- 404 Not Found ---
        http_response_code(404);
        // You can create a dedicated 404 view later
        echo 
        "<h1>404 Not Found</h1><p>The requested page was not found.</p>";
        break;
}

?>
