<?php
// /home/ubuntu/vtrius_web_system/src/Views/auth/login.php

// Set page title key (header will translate it)
$pageTitleKey = "login_title";

?>

<div class="container" style="max-width: 400px; margin-top: 50px;">
    <h2 style="text-align: center;"><?php echo __("login_heading"); ?></h2>

    <?php 
    // Display login errors passed from controller
    if (isset($error)): ?>
        <p class="flash-message flash-error" style="text-align: center;"><?php echo htmlspecialchars($error); // Error message should be translated in controller ?></p>
    <?php endif; ?>
    <?php
    // Display generic query parameter errors (e.g., from requireLogin redirects)
    if (isset($_GET["error"])) {
        $errorKey = match ($_GET["error"]) {
            "account_inactive" => "login_error_inactive",
            "access_denied" => "login_error_access_denied",
            default => "error" // Generic error key
        };
        echo 
        '<p class="flash-message flash-error" style="text-align: center;">' . htmlspecialchars(__($errorKey)) . '</p>';
    }
    ?>

    <form action="<?php echo BASE_URL; ?>/login.php" method="post" style="padding: 20px; border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9;">
        <div style="margin-bottom: 15px;">
            <label for="username" style="display: block; margin-bottom: 5px; font-weight: bold;"><?php echo __("username"); ?>:</label>
            <input type="text" id="username" name="username" required style="width: calc(100% - 22px); padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
        </div>
        <div style="margin-bottom: 20px;">
            <label for="password" style="display: block; margin-bottom: 5px; font-weight: bold;"><?php echo __("password"); ?>:</label>
            <input type="password" id="password" name="password" required style="width: calc(100% - 22px); padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
        </div>
        <button type="submit" style="width: 100%; padding: 12px; background-color: #556B2F; /* Dark Olive Green */ color: white; border: none; border-radius: 4px; font-size: 1em; cursor: pointer;"><?php echo __("login_button"); ?></button>
    </form>
    
    <!-- Optional: Add link for password recovery or registration later -->
    <!-- <p style="text-align: center; margin-top: 15px;"><a href="/forgot-password.php"><?php echo __("forgot_password"); ?></a></p> -->

</div>

<?php
// Note: This view assumes header.php and footer.php are included by the controller
// or a front controller (index.php).
// The generic header/footer should be used for the login page.
?>

