# Sistema Web Vtrius

Este projeto é um sistema web completo para hospedagem, gerenciamento e exibição de vídeos com funcionalidades avançadas de marketing, semelhante ao Vturb.

## Funcionalidades Principais

*   **Gerenciamento de Vídeos:** Upload, listagem e exclusão de vídeos.
*   **Player Personalizado:** Player HTML5 com opções de ocultar controles, autoplay (muted), overlay de imagem com opacidade e capa de pausa com botões (continuar/reiniciar).
*   **Funcionalidades de Marketing:**
    *   **Pitch Container:** Exibe um container HTML (definido por seletor CSS) ou um botão configurável (texto e URL) em um tempo específico do vídeo.
*   **Testes A/B:** Crie testes com múltiplas variações de vídeo (até 4), obtenha um código de incorporação que exibe uma variação aleatória e visualize estatísticas básicas (a coletar).
*   **Sistema de Contas:**
    *   Login unificado para usuários e administradores.
    *   Controle de acesso baseado em status (ativo, inativo, congelado) e data de expiração.
    *   Painel de administração (a ser totalmente implementado) para gerenciar usuários (criar, definir expiração, congelar/descongelar).
*   **Internacionalização (i18n):** Suporte para Português (pt_BR), Inglês (en_US) e Espanhol (es_ES) com seletor de idioma.

## Estrutura do Projeto

```
/home/ubuntu/vtrius_web_system/
├── db/                     # Arquivos do banco de dados
│   ├── schema.sql          # Esquema SQL do banco de dados
│   └── vtrius_database.db  # Arquivo do banco de dados SQLite (criado)
├── public/                 # Diretório raiz público (configurar web server aqui)
│   ├── assets/             # Arquivos CSS, JS, imagens
│   │   ├── css/
│   │   │   └── style.css
│   │   ├── img/flags/      # Imagens das bandeiras de idioma
│   │   │   ├── br.png
│   │   │   ├── us.png
│   │   │   └── es.png
│   │   └── js/
│   │       ├── main.js
│   │       └── vtrius-player.js # Lógica do player de vídeo
│   ├── uploads/            # Diretório para arquivos carregados (vídeos, overlays, etc.)
│   │   ├── videos/
│   │   ├── overlays/
│   │   └── pause_covers/
│   ├── api/                # Endpoints da API pública
│   │   └── abtest_data.php # API para dados de teste A/B
│   ├── index.php           # Ponto de entrada principal / Roteador
│   └── ab_player.js        # Script de incorporação para testes A/B
├── src/                    # Código fonte da aplicação PHP
│   ├── Controllers/        # Controladores (lógica de requisição)
│   ├── Lib/                # Bibliotecas principais (Auth, Database, I18n)
│   ├── Locale/             # Arquivos de tradução
│   │   ├── en_US/
│   │   ├── es_ES/
│   │   └── pt_BR/
│   ├── Models/             # Modelos (interação com banco de dados)
│   └── Views/              # Arquivos de template (HTML/PHP)
│       ├── auth/
│       ├── layouts/
│       ├── partials/
│       └── user/
│           ├── abtests/
│           └── videos/
├── .htaccess               # (Opcional/Exemplo) Configuração para Apache
├── config.php              # Arquivo de configuração principal (movido para src/)
├── db_init.php             # Script para inicializar o banco de dados
└── README.md               # Este arquivo
```

## Configuração

1.  **Servidor Web:** Configure um servidor web (como Apache ou Nginx) com suporte a PHP (versão 8.1 ou superior recomendada) e a extensão `php-sqlite3` instalada.
    *   Aponte a raiz do documento do servidor para o diretório `public/`.
    *   Certifique-se de que o servidor tenha permissão de escrita nos diretórios `db/` e `public/uploads/` (e seus subdiretórios).
    *   **Reescrita de URL (Opcional, mas recomendado):** Configure a reescrita de URL para que as requisições sejam direcionadas para `index.php` (Exemplo para Apache em `.htaccess` pode ser necessário).

2.  **Banco de Dados:** Execute o script de inicialização via linha de comando a partir do diretório raiz do projeto (`/home/ubuntu/vtrius_web_system/`):
    ```bash
    php db_init.php
    ```
    Isso criará o arquivo `db/vtrius_database.db` com as tabelas necessárias e adicionará usuários iniciais:
    *   **Admin:** `admin` / `admin123`
    *   **Usuário:** `testuser` / `test1234` (expira em 30 dias)

3.  **Acesso:** Acesse o sistema através do URL configurado no seu servidor web.

## Uso Básico

1.  **Login:** Use as credenciais `admin`/`admin123` para acesso administrativo (funcionalidades de admin ainda precisam ser implementadas) ou `testuser`/`test1234` para acesso de usuário.
2.  **Área do Usuário:**
    *   **Carregar Vídeos:** Faça upload de arquivos de vídeo.
    *   **Gerenciar Vídeos:** Veja a lista de vídeos, obtenha o código de incorporação (exemplo) e acesse as configurações.
    *   **Configurar Vídeo:** Ajuste o comportamento do player (controles, autoplay), adicione overlay, capa de pausa e configure o pitch (seletor CSS ou botão).
    *   **Testes A/B:** Crie testes, adicione vídeos como variações e obtenha o código de incorporação do teste.

## Próximos Passos / Melhorias

*   Implementar completamente o painel de administração (gerenciamento de usuários, criação, expiração, congelamento).
*   Implementar a coleta e exibição de estatísticas para os testes A/B.
*   Adicionar validação mais robusta e tratamento de erros.
*   Melhorar a segurança (senhas mais fortes, proteção CSRF, etc.).
*   Refinar o design da interface do usuário.
*   Otimizar o carregamento de vídeos e assets.
*   Implementar a funcionalidade de otimização de carregamento no script de embed.
*   Adicionar paginação e busca nas listas.
*   Considerar um framework PHP (como Laravel ou Symfony) para projetos maiores.

