<?php
// /home/ubuntu/vtrius_web_system/db_init.php

// Initializes the database and creates initial users.
require_once __DIR__ . '/src/config.php';use Vtrius\Lib\Database;
use Vtrius\Models\User;

// --- Initialize Database Schema ---
echo 
"Initializing database schema...\n
";
try {
    $db = Database::getConnection();
    $schemaSql = file_get_contents(dirname(DB_PATH) . '/schema.sql');
    if ($schemaSql === false) {
        throw new Exception(
        "Could not read schema.sql
        ");
    }
    // Execute schema SQL (PDO::exec supports multiple statements)
    $db->exec($schemaSql);
    echo 
    "Database schema initialized successfully.\n
    ";

} catch (\Exception $e) {
    echo 
    "Error initializing database schema: 
    " . $e->getMessage() . 
    "\n
    ";
    exit(1);
}

// --- Create Initial Users ---
echo 
"Creating initial users...\n
";

$userModel = new User();

// Admin User
$adminUsername = 
"admin
";
$adminPassword = 
"admin123
"; // Use a stronger password in production!
$adminEmail = 
"admin@example.com
";

try {
    if (!$userModel->findByUsername($adminUsername)) {
        $userId = $userModel->create(
            $adminUsername,
            $adminPassword,
            $adminEmail,
            
            true, // is_admin
            
            null // expiry_date (admin doesn't expire)
        );
        if ($userId) {
            echo 
            "Admin user '
            " . $adminUsername . 
            "' created successfully (Password: 
            " . $adminPassword . 
            ").\n
            ";
        } else {
            echo 
            "Failed to create admin user.\n
            ";
        }
    } else {
        echo 
        "Admin user '
        " . $adminUsername . 
        "' already exists.\n
        ";
    }
} catch (\Exception $e) {
    echo 
    "Error creating admin user: 
    " . $e->getMessage() . 
    "\n
    ";
}

// Regular User
$testUsername = 
"testuser
";
$testPassword = 
"test1234
"; // Use a stronger password in production!
$testEmail = 
"test@example.com
";
$expiryDate = (new DateTime(
"+30 days
"))->format(
"Y-m-d H:i:s
");

try {
    if (!$userModel->findByUsername($testUsername)) {
        $userId = $userModel->create(
            $testUsername,
            $testPassword,
            $testEmail,
            
            false, // is_admin
            $expiryDate
        );
        if ($userId) {
            echo 
            "Test user '
            " . $testUsername . 
            "' created successfully (Password: 
            " . $testPassword . 
            ", Expires: 
            " . $expiryDate . 
            ").\n
            ";
        } else {
            echo 
            "Failed to create test user.\n
            ";
        }
    } else {
        echo 
        "Test user '
        " . $testUsername . 
        "' already exists.\n
        ";
    }
} catch (\Exception $e) {
    echo 
    "Error creating test user: 
    " . $e->getMessage() . 
    "\n
    ";
}

echo 
"Database initialization complete.\n
";

?>

