// /home/ubuntu/vtrius_web_system/public/ab_player.js
// Embed script for Vtrius A/B Tests

(function() {
    // Find the script element itself to get the test ID
    const scriptElement = document.currentScript;
    if (!scriptElement) {
        console.error("Vtrius A/B Player Error: Could not find the script element.");
        return;
    }

    const scriptSrc = scriptElement.src;
    const urlParams = new URLSearchParams(scriptSrc.split("?")[1]);
    const testId = urlParams.get("test");

    if (!testId) {
        console.error("Vtrius A/B Player Error: Test ID not found in script URL.");
        return;
    }

    // Create a unique placeholder div where the script was placed
    const placeholderId = `vtrius-ab-placeholder-${testId}-${Math.random().toString(36).substring(2, 9)}`;
    const placeholderDiv = document.createElement("div");
    placeholderDiv.id = placeholderId;
    // Basic styling for the placeholder - aspect ratio ensures space is reserved
    placeholderDiv.style.width = "100%";
    placeholderDiv.style.maxWidth = "100%"; 
    placeholderDiv.style.aspectRatio = "16 / 9"; 
    placeholderDiv.style.backgroundColor = "#000"; 
    placeholderDiv.style.position = "relative"; // For potential loading indicators
    
    // Insert the placeholder div right after the script tag
    scriptElement.parentNode.insertBefore(placeholderDiv, scriptElement.nextSibling);

    // Determine the base URL for the API call (assuming API is in the same domain/path)
    // More robust: Extract base URL from scriptSrc or have it configured globally
    const baseUrl = scriptSrc.substring(0, scriptSrc.lastIndexOf("/")); 
    const apiUrl = `${baseUrl}/api/abtest_data.php?test=${testId}`;

    // Fetch the data for a random variation
    fetch(apiUrl)
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(playerData => {
            if (playerData.error) {
                throw new Error(playerData.error);
            }

            // Dynamically load the main VtriusPlayer script if not already loaded
            // This is a simple check; a more robust solution might use a global flag
            if (typeof VtriusPlayer === "undefined") {
                const mainPlayerScript = document.createElement("script");
                mainPlayerScript.src = `${baseUrl}/assets/js/vtrius-player.js`; // Adjust path if needed
                mainPlayerScript.async = false; // Load synchronously before initializing
                mainPlayerScript.onload = () => {
                    initializePlayer(placeholderId, playerData);
                };
                mainPlayerScript.onerror = () => {
                     console.error("Vtrius A/B Player Error: Failed to load vtrius-player.js");
                     placeholderDiv.innerHTML = "Error loading player."; // Display error in placeholder
                };
                document.body.appendChild(mainPlayerScript);
            } else {
                initializePlayer(placeholderId, playerData);
            }
        })
        .catch(error => {
            console.error("Vtrius A/B Player Error: Failed to fetch or initialize player:", error);
            placeholderDiv.innerHTML = "Error loading video data."; // Display error in placeholder
        });

    function initializePlayer(containerId, options) {
         // Ensure the container exists before initializing
        if (!document.getElementById(containerId)) {
            console.error(`Vtrius A/B Player Error: Placeholder container #${containerId} not found during initialization.`);
            return;
        }
        console.log(`Vtrius A/B Player: Initializing player in #${containerId} for variation ${options.variationId}`);
        new VtriusPlayer(containerId, options);
        // TODO: Add tracking call here to record a view for options.variationId
        // trackAbTestView(options.variationId);
    }

    // Placeholder for tracking function
    // function trackAbTestView(variationId) {
    //     // Send a request to a tracking endpoint (e.g., /api/track_view.php?variation=variationId)
    //     // Use navigator.sendBeacon() for reliability if possible
    //     console.log(`Tracking view for variation ${variationId}`);
    //     // fetch(`/api/track_view.php?variation=${variationId}`, { method: 'POST', keepalive: true });
    // }

})();

