<?php
// /home/ubuntu/vtrius_web_system/src/Views/user/abtests/view.php

// $test, $variations, $userVideos, $stats are passed from AbTestController::viewTest()
// $pageTitleKey is set by the controller

$pageTitle = isset($pageTitleKey) ? __($pageTitleKey, ["name" => $test["name"]]) : __("ab_test_view_title_default"); // Needs translation

?>

<h2><?php echo $pageTitle; ?></h2>

<style>
    .variations-list, .add-variation-form, .stats-section {
        margin-bottom: 30px;
        padding: 20px;
        border: 1px solid #eee;
        border-radius: 4px;
        background-color: #fdfdfd;
    }
    .variations-list h3, .add-variation-form h3, .stats-section h3 {
        margin-top: 0;
        margin-bottom: 15px;
        color: #2F4F2F;
    }
    .variations-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
    }
    .variations-table th, .variations-table td {
        border: 1px solid #dee2e6;
        padding: 8px 10px;
        text-align: left;
        vertical-align: middle;
    }
    .variations-table th {
        background-color: #e9ecef;
    }
    .variations-table .actions form {
        display: inline-block;
    }
    .variations-table .actions button {
        padding: 3px 8px;
        font-size: 0.85em;
    }
    .variations-table .control-label {
        font-weight: bold;
        color: #198754; /* Green */
    }
    .add-variation-form select {
        padding: 8px;
        margin-right: 10px;
    }
    .embed-code code {
        display: block;
        background-color: #e9ecef;
        padding: 10px;
        border-radius: 3px;
        font-family: monospace;
        font-size: 0.9em;
        word-break: break-all;
        margin-top: 10px;
    }
</style>

<div class="variations-list">
    <h3><?php echo __("ab_test_variations_heading"); ?></h3>
    <?php if (empty($variations)): ?>
        <p><?php echo __("ab_test_no_variations_yet"); ?></p>
    <?php else: ?>
        <table class="variations-table">
            <thead>
                <tr>
                    <th><?php echo __("ab_test_video_title_column"); ?></th>
                    <th><?php echo __("ab_test_status_column"); ?></th>
                    <th><?php echo __("actions"); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($variations as $variation): ?>
                <tr>
                    <td><?php echo htmlspecialchars($variation["title"]); ?> (ID: <?php echo $variation["id"]; ?>)</td>
                    <td>
                        <?php if ($variation["is_control"]): ?>
                            <span class="control-label"><?php echo __("ab_test_control_label"); ?></span>
                        <?php else: ?>
                            <?php echo __("ab_test_variation_label"); ?>
                        <?php endif; ?>
                    </td>
                    <td class="actions">
                        <?php if (!$variation["is_control"]): ?>
                            <form action="<?php echo BASE_URL; ?>/user/abtests/remove_variation.php" method="post" onsubmit="return confirm("<?php echo htmlspecialchars(__("ab_test_confirm_remove_variation")); ?>");">
                                <input type="hidden" name="variation_id" value="<?php echo $variation["variation_id"]; ?>">
                                <input type="hidden" name="test_id" value="<?php echo $test["id"]; ?>">
                                <button type="submit" class="btn-delete"><?php echo __("remove"); ?></button>
                            </form>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<?php if (count($variations) < 4): ?>
<div class="add-variation-form">
    <h3><?php echo __("ab_test_add_variation_heading"); ?></h3>
    <form action="<?php echo BASE_URL; ?>/user/abtests/add_variation.php" method="post">
        <input type="hidden" name="test_id" value="<?php echo $test["id"]; ?>">
        <label for="video_id" style="margin-right: 10px;"><?php echo __("ab_test_select_video_to_add"); ?></label>
        <select id="video_id" name="video_id" required>
            <option value=""><?php echo __("ab_test_form_select_video_option"); ?></option>
            <?php 
            $currentVideoIds = array_column($variations, "id");
            foreach ($userVideos as $video): 
                // Only show videos not already in the test
                if (!in_array($video["id"], $currentVideoIds)): ?>
                <option value="<?php echo $video["id"]; ?>">
                    <?php echo htmlspecialchars($video["title"]); ?> (ID: <?php echo $video["id"]; ?>)
                </option>
            <?php endif; endforeach; ?>
        </select>
        <button type="submit" class="button"><?php echo __("ab_test_add_variation_button"); ?></button>
    </form>
    <small><?php echo __("ab_test_variation_limit_desc"); ?></small>
</div>
<?php else: ?>
<div class="add-variation-form">
     <p><?php echo __("ab_test_variation_limit_reached"); ?></p>
</div>
<?php endif; ?>

<div class="stats-section">
    <h3><?php echo __("ab_test_stats_heading"); ?></h3>
    <p><?php echo __("ab_test_stats_coming_soon"); ?></p>
    <!-- TODO: Display stats table/chart here -->
</div>

<div class="embed-code">
    <h3><?php echo __("ab_test_embed_code_heading"); ?></h3>
    <?php 
    // Placeholder for A/B test embed code generation
    $embedCode = "<script src=\"" . BASE_URL . "/ab_player.js?test=" . $test["id"] . "\" async></script>"; 
    ?>
    <code><?php echo htmlspecialchars($embedCode); ?></code>
    <small><?php echo __("ab_test_embed_code_desc"); ?></small>
</div>

<p style="margin-top: 30px;"><a href="<?php echo BASE_URL; ?>/user/abtests.php"><?php echo __("back_to_ab_tests_list"); ?></a></p>

<?php
// Add new translation keys:
/*
"ab_test_view_title" => "Gerenciar Teste A/B: :name",
"ab_test_view_title_default" => "Gerenciar Teste A/B",
"ab_test_variations_heading" => "Variações do Teste",
"ab_test_no_variations_yet" => "Nenhuma variação adicionada ainda (exceto o controle).",
"ab_test_video_title_column" => "Título do Vídeo",
"ab_test_status_column" => "Status",
"ab_test_control_label" => "Controle",
"ab_test_variation_label" => "Variação",
"ab_test_confirm_remove_variation" => "Tem certeza que deseja remover esta variação do teste?",
"remove" => "Remover",
"ab_test_add_variation_heading" => "Adicionar Nova Variação",
"ab_test_select_video_to_add" => "Selecione um vídeo para adicionar como variação:",
"ab_test_add_variation_button" => "Adicionar Variação",
"ab_test_variation_limit_desc" => "Você pode ter até 4 variações (incluindo o controle) por teste.",
"ab_test_variation_limit_reached" => "Limite de 4 variações atingido para este teste.",
"ab_test_stats_heading" => "Estatísticas (Em Breve)",
"ab_test_stats_coming_soon" => "A coleta e exibição de estatísticas serão implementadas em breve.",
"ab_test_embed_code_heading" => "Código de Incorporação do Teste A/B",
"ab_test_embed_code_desc" => "Copie e cole este código onde você deseja exibir o teste A/B. O sistema selecionará aleatoriamente uma das variações para cada visitante.",
"back_to_ab_tests_list" => "Voltar para a Lista de Testes A/B",
"ab_test_error_not_found" => "Teste A/B não encontrado ou não pertence a você.",
"ab_test_variation_add_success" => "Variação adicionada ao teste com sucesso.",
"ab_test_variation_add_error" => "Erro ao adicionar variação. Ela já pode existir neste teste.",
"ab_test_error_variation_limit" => "Erro: Limite de 4 variações por teste atingido.",
"ab_test_variation_remove_success" => "Variação removida com sucesso.",
"ab_test_variation_remove_error" => "Erro ao remover variação. Não é possível remover a variação de controle.",
"ab_test_delete_success" => "Teste A/B excluído com sucesso.",
"ab_test_delete_error" => "Erro ao excluir o Teste A/B.",
*/
?>

