<?php
// /home/ubuntu/vtrius_web_system/src/Views/user/videos/settings.php

// $video and $settings are passed from VideoSettingsController::showSettingsForm()
// $pageTitleKey is set by the controller

$pageTitle = isset($pageTitleKey) ? __($pageTitleKey, ["title" => $video["title"]]) : __("video_settings_title_default"); // Needs translation key

function render_image_field(string $fieldName, string $labelKey, ?string $currentPath, string $uploadDirUrl) {
    $inputId = $fieldName;
    $removeId = "remove_" . $fieldName;
    $currentImageUrl = $currentPath ? $uploadDirUrl . "/" . htmlspecialchars($currentPath) : null;

    echo 
    "<div class=\"form-group\"><label>". __($labelKey) . ":</label>";
    if ($currentImageUrl) {
        echo 
        "<div style=\"margin-bottom: 10px;\"><img src=\"" . $currentImageUrl . "\" alt=\"" . __($labelKey) . "\" style=\"max-width: 200px; max-height: 100px; display: block; margin-bottom: 5px;\">";
        echo 
        "<label for=\"" . $removeId . "\" style=\"font-size: 0.9em;\"><input type=\"checkbox\" id=\"" . $removeId . "\" name=\"" . $removeId . "\" value=\"1\"> " . __("remove_current_image") . "</label></div>"; // Needs translation
    }
    echo 
    "<input type=\"file\" id=\"" . $inputId . "\" name=\"" . $fieldName . "\" accept=\"image/jpeg,image/png,image/gif,image/webp\">";
    echo 
    "<small>" . __("form_image_allowed_types") . "</small></div>"; // Needs translation
}

?>

<h2><?php echo $pageTitle; ?></h2>

<form action="<?php echo BASE_URL; ?>/user/videos/settings.php" method="post" enctype="multipart/form-data">
    <input type="hidden" name="video_id" value="<?php echo $video["id"]; ?>">

    <style>
        .form-group {
            margin-bottom: 20px;
            padding: 15px;
            border: 1px solid #eee;
            border-radius: 4px;
            background-color: #fdfdfd;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
        }
        .form-group input[type="text"],
        .form-group input[type="number"],
        .form-group input[type="url"],
        .form-group input[type="range"],
        .form-group textarea {
            width: calc(100% - 22px);
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .form-group input[type="checkbox"] {
            margin-right: 5px;
        }
        .form-group small {
            display: block;
            margin-top: 5px;
            color: #6c757d;
            font-size: 0.9em;
        }
        .form-section {
            margin-bottom: 30px;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 20px;
        }
        .form-section h3 {
            margin-top: 0;
            margin-bottom: 15px;
            color: #2F4F2F; /* Dark Moss Green */
        }
    </style>

    <div class="form-section">
        <h3><?php echo __("settings_section_player_behavior"); ?></h3>
        <div class="form-group">
            <label for="hide_controls">
                <input type="checkbox" id="hide_controls" name="hide_controls" value="1" <?php echo ($settings["hide_controls"] ?? 0) ? "checked" : ""; ?>>
                <?php echo __("setting_hide_controls_label"); ?>
            </label>
            <small><?php echo __("setting_hide_controls_desc"); ?></small>
        </div>
        <div class="form-group">
            <label for="autoplay">
                <input type="checkbox" id="autoplay" name="autoplay" value="1" <?php echo ($settings["autoplay"] ?? 0) ? "checked" : ""; ?>>
                <?php echo __("setting_autoplay_label"); ?>
            </label>
            <small><?php echo __("setting_autoplay_desc"); ?></small>
        </div>
    </div>

    <div class="form-section">
        <h3><?php echo __("settings_section_overlay"); ?></h3>
        <?php render_image_field("overlay_image", "setting_overlay_image_label", $settings["overlay_image_path"] ?? null, BASE_URL . "/uploads/overlays"); ?>
        <div class="form-group">
            <label for="overlay_opacity"><?php echo __("setting_overlay_opacity_label"); ?></label>
            <input type="range" id="overlay_opacity" name="overlay_opacity" min="0" max="1" step="0.1" value="<?php echo htmlspecialchars($settings["overlay_opacity"] ?? 1.0); ?>" style="width: 200px; vertical-align: middle;">
            <span id="overlay_opacity_value" style="margin-left: 10px;"><?php echo htmlspecialchars($settings["overlay_opacity"] ?? 1.0); ?></span>
            <script>document.getElementById("overlay_opacity").oninput = function() { document.getElementById("overlay_opacity_value").textContent = this.value; }</script>
            <small><?php echo __("setting_overlay_opacity_desc"); ?></small>
        </div>
    </div>

    <div class="form-section">
        <h3><?php echo __("settings_section_pause_cover"); ?></h3>
        <?php render_image_field("pause_cover_image", "setting_pause_cover_image_label", $settings["pause_cover_image_path"] ?? null, BASE_URL . "/uploads/pause_covers"); ?>
        <div class="form-group">
            <label for="pause_cover_text"><?php echo __("setting_pause_cover_text_label"); ?></label>
            <input type="text" id="pause_cover_text" name="pause_cover_text" value="<?php echo htmlspecialchars($settings["pause_cover_text"] ?? ""); ?>" placeholder="<?php echo __("pause_cover_default_text"); ?>">
            <small><?php echo __("setting_pause_cover_text_desc"); ?></small>
        </div>
        <!-- TODO: Add fields for pause cover buttons if needed -->
    </div>

    <div class="form-section">
        <h3><?php echo __("settings_section_pitch_container"); ?></h3>
        <div class="form-group">
            <label for="pitch_time_seconds"><?php echo __("setting_pitch_time_label"); ?></label>
            <input type="number" id="pitch_time_seconds" name="pitch_time_seconds" value="<?php echo htmlspecialchars($settings["pitch_time_seconds"] ?? ""); ?>" min="0" step="1">
            <small><?php echo __("setting_pitch_time_desc"); ?></small>
        </div>
        <div class="form-group">
            <label for="pitch_target_selector"><?php echo __("setting_pitch_target_selector_label"); ?></label>
            <input type="text" id="pitch_target_selector" name="pitch_target_selector" value="<?php echo htmlspecialchars($settings["pitch_target_selector"] ?? ""); ?>" placeholder="#meu-container, .minha-classe">
            <small><?php echo __("setting_pitch_target_selector_desc"); ?></small>
        </div>
        
        <hr style="margin: 20px 0; border-top: 1px dashed #ccc;">
        <p style="text-align: center; margin-bottom: 15px; font-style: italic;"><?php echo __("setting_pitch_option_or"); ?></p>
        
        <div class="form-group">
            <label for="pitch_button_text"><?php echo __("setting_pitch_button_text_label"); ?></label>
            <input type="text" id="pitch_button_text" name="pitch_button_text" value="<?php echo htmlspecialchars($settings["pitch_button_text"] ?? ""); ?>">
            <small><?php echo __("setting_pitch_button_text_desc"); ?></small>
        </div>
        <div class="form-group">
            <label for="pitch_button_url"><?php echo __("setting_pitch_button_url_label"); ?></label>
            <input type="url" id="pitch_button_url" name="pitch_button_url" value="<?php echo htmlspecialchars($settings["pitch_button_url"] ?? ""); ?>" placeholder="https://...">
            <small><?php echo __("setting_pitch_button_url_desc"); ?></small>
        </div>
        <small><?php echo __("setting_pitch_button_note"); ?></small>
    </div>

    <button type="submit" class="button"><?php echo __("save_settings"); ?></button>
    <a href="<?php echo BASE_URL; ?>/user/videos.php" style="margin-left: 15px;"><?php echo __("back_to_videos"); ?></a>

</form>

<?php
// Add new translation keys used here to the messages.php files
/*
"video_settings_title" => "Configurações do Vídeo: :title",
"video_settings_title_default" => "Configurações do Vídeo",
"settings_section_player_behavior" => "Comportamento do Player",
"setting_hide_controls_label" => "Ocultar controles padrão do player",
"setting_hide_controls_desc" => "Se marcado, os controles nativos do navegador serão ocultados. Você pode precisar implementar controles personalizados.",
"setting_autoplay_label" => "Autoplay (com mudo)",
"setting_autoplay_desc" => "Tenta iniciar o vídeo automaticamente (geralmente requer mudo inicial). Pode ser bloqueado por navegadores.",
"settings_section_overlay" => "Overlay de Imagem",
"setting_overlay_image_label" => "Imagem de Overlay",
"remove_current_image" => "Remover imagem atual",
"form_image_allowed_types" => "Tipos permitidos: JPG, PNG, GIF, WebP. Tamanho máx: 5MB.",
"setting_overlay_opacity_label" => "Opacidade do Overlay",
"setting_overlay_opacity_desc" => "Define a transparência da imagem de overlay (0 = transparente, 1 = opaco).",
"settings_section_pause_cover" => "Capa de Pausa",
"setting_pause_cover_image_label" => "Imagem da Capa de Pausa",
"setting_pause_cover_text_label" => "Texto na Capa de Pausa",
"pause_cover_default_text" => "Você já estava assistindo...",
"setting_pause_cover_text_desc" => "Texto exibido sobre a imagem quando o vídeo é pausado.",
"settings_section_pitch_container" => "Pitch / CTA",
"setting_pitch_time_label" => "Tempo para exibir Pitch (em segundos)",
"setting_pitch_time_desc" => "Deixe em branco para desativar. O conteúdo será exibido após este tempo.",
"setting_pitch_target_selector_label" => "Seletor CSS do Container do Pitch",
"setting_pitch_target_selector_desc" => "Ex: #meu-id, .minha-classe. O player removerá a classe 'vtrius-pitch-hidden' deste elemento no tempo definido.",
"save_settings" => "Salvar Configurações",
"back_to_videos" => "Voltar para Vídeos",
"video_settings_update_success" => "Configurações do vídeo atualizadas com sucesso.",
"video_settings_update_error" => "Erro ao atualizar as configurações do vídeo.",
"upload_error_image_type" => "Erro: Tipo de arquivo de imagem não permitido.",
"upload_error_image_size" => "Erro: Arquivo de imagem excede o tamanho máximo permitido (:size MB).",
"pause_cover_continue_button" => "Continuar de onde parou", // Used by JS player
"pause_cover_restart_button" => "Reiniciar do início", // Used by JS player
*/
?>

